/**
 * subsetSum-1.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Determines if a set has a subset with sum equal to given sum.
 *
 * Demonstrates dynamic programming.
 *
 * Adopted from http://www.geeksforgeeks.org/dynamic-programming-subset-sum-problem/.
 */

#include <iostream>
#include <vector>
using namespace std;

/**
 * @return true if set has a subset whose elements' sum is equal to sum.
 */
bool isSubsetSum(int set[], int n, int sum);

int main() {
    int numbers[] = {1, 5, 7, 48, 2, 8, 4, 6};
    int n = sizeof(numbers) / sizeof(numbers[0]);
    int sum = 10;
    
    if (isSubsetSum(numbers, n, sum)) {
        cout << "Found subset sum!" << endl;
    } else {
        cout << "No subset sum. :(" << endl;
    }
}

bool isSubsetSum(int set[], const int n, const int sum) {
    // store intermediate calculations
    vector<vector<bool>> memo = vector<vector<bool>>(n + 1, vector<bool>(sum + 1, false));
    
    // if sum is 0, answer is yes
    for (int i = 0; i <= n; i++) {
        memo[i][0] = true;
    }
    
    // if sum is not 0 and set is empty, answer is no
    for (int i = 1; i <= sum; i++) {
        memo[0][i] = false;
    }
    
    // fill the memo table bottom-up
    for (int i = 1; i <= n; i++) {
        for (int j = 1; j <= sum; j++) {
            // excluding this element
            memo[i][j] = memo[i - 1][j];
            
            // last element is not greater than sum
            if (j >= set[i - 1]) {
                memo[i][j] = memo[i][j] || memo[i - 1][j - set[i - 1]];
            }
        }
    }
    
    return memo[n][sum];
}
