/**
 * subsetSum-0.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Determines if a set has a subset with sum equal to given sum.
 *
 * Demonstrates bad design.
 *
 * Adopted from http://www.geeksforgeeks.org/dynamic-programming-subset-sum-problem/.
 */

#include <iostream>
using namespace std;

/**
 * @return true if set has a subset whose elements' sum is equal to sum.
 */
bool isSubsetSum(int set[], int n, int sum);

int main()
{
    int numbers[] = {1, 5, 7, 48, 2, 8, 4, 6};
    int n = sizeof(numbers) / sizeof(numbers[0]);
    int sum = 10;
    
    if (isSubsetSum(numbers, n, sum)) {
        cout << "Found subset sum!" << endl;
    }
    else {
        cout << "No subset sum. :(" << endl;
    }
}

bool isSubsetSum(int set[], int n, int sum) {
    // base cases
    if (sum == 0) {
        return true;
    } else if (n == 0 && sum != 0) {
        return false;
    }
    
    // if last element is greater than sum, ignore it
    if (set[n-1] > sum) {
        return isSubsetSum(set, n-1, sum);
    }
    
    // check if we can get sum by including or excluding the last element
    return isSubsetSum(set, n - 1, sum) ||
           isSubsetSum(set, n - 1, sum - set[n - 1]);
}
