/**
 * fib-3.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Computes nth Fibonacci number.
 *
 * Improves upon dynamic programming.
 */

#include <iostream>
using namespace std;

/**
 * @return nth number in Fibonacci sequence.
 */
long long int fib(int n);

int main() {
    // get input form user
    cout << "Enter a non-negative number: ";
    int n;
    cin >> n;
    
    // validate input
    if (n < 0) {
        cout << "Input must be non-negative." << endl;
        return 1;
    } else {
        // compute and print nth fibonacci number
        cout << "fib(" << n << ") = " << fib(n) << endl;
        return 0;
    }
}

long long int fib(int n) {
    // base cases
    if (n == 0) {
        return 0;
    } else if (n == 1) {
        return 1;
    }
    
    // start saving previous values
    long long int prevPrev = 0;
    long long int prev = 1;
    long long int current = 0;
    
    // solve subproblems using previously computed values
    for (int i = 2; i <= n; i++) {
        current = prev + prevPrev;
        prevPrev = prev;
        prev = current;
    }
    
    return current;
}

