/**
 * fib-2.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Computes nth Fibonacci number.
 *
 * Demonstrates memoization using bottom-up approach.
 */

#include <iostream>
#include <vector>
using namespace std;

/**
 * @return nth number in Fibonacci sequence.
 */
long long int fib(int n);

int main() {
    // get input form user
    cout << "Enter a non-negative number: ";
    int n;
    cin >> n;
    
    // validate input
    if (n < 0) {
        cout << "Input must be non-negative." << endl;
        return 1;
    } else {
        // compute and print nth fibonacci number
        cout << "fib(" << n << ") = " << fib(n) << endl;
        return 0;
    }
}

long long int fib(int n) {
    // initialize memo, using sentinel for answers not yet computed
    vector<long long int> memo(n + 1);
    
    // base case
    memo[0] = 0;
    if (n >= 1) {
        memo[1] = 1;
    }
    
    for (int i = 2; i <= n; i++) {
        memo[i] = memo[i - 1] + memo[i - 2];
    }
    
    // compute nth fibonacci number
    long long int answer = memo[n];
    
    return answer;
}

