/**
 * fib-1.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Computes nth Fibonacci number.
 *
 * Demonstrates dynamic programming and memoization.
 */

#include <iostream>
#include <vector>
using namespace std;

/**
 * @return nth number in Fibonacci sequence.
 */
long long int fib(int n);

/**
 * Uses `cache` vector to store intermediate results.
 *
 * @return nth number in Fibonacci sequence.
 */
long long int fibHelper(int n, vector<long long int> &cache);

const long long int SENTINEL = -1;

int main() {
    // get input form user
    cout << "Enter a non-negative number: ";
    int n;
    cin >> n;
    
    // validate input
    if (n < 0) {
        cout << "Input must be non-negative." << endl;
        return 1;
    } else {
        // compute and print nth fibonacci number
        cout << "fib(" << n << ") = " << fib(n) << endl;
        return 0;
    }
}

long long int fib(int n) {
    // initialize memo, using sentinel for answers not yet computed
    vector<long long int> memo(n + 1, SENTINEL);
    
    // base case
    memo[0] = 0;
    if (n >= 1) {
        memo[1] = 1;
    }
    
    // compute nth fibonacci number
    long long int answer = fibHelper(n, memo);
    
    return answer;
}

long long int fibHelper(int n, vector<long long int> &cache) {
    // check if nth fibonacci number has not been computed
    if (cache[n] == SENTINEL) {
        cache[n] = fibHelper(n - 1, cache) + fibHelper(n - 2, cache);
    }
    return cache[n];
}
