/**
 * newQueue.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Demonstrates a queue implemented with two stacks.
 */

#include <iostream>
#include <stack>
using namespace std;

template <typename T>
class NewQueue {
    std::stack<T> input;
    std::stack<T> output;

public:
    size_t size() {
        return input.size() + output.size();
    }

    bool empty() {
        return size() == 0;
    }

    void push(const T& element) {
        input.push(element);
    }

    void pop() {
        if (output.empty()) {
            while (!input.empty()) {
                output.push(input.top());
                input.pop();
            }
        }
        output.pop();
    }

    T top() {
        if (output.empty()) {
            while (!input.empty()) {
                output.push(input.top());
                input.pop();
            }
        }
        return output.top();
    }
};

int main() {
    NewQueue<int> queue;
    queue.push(1);
    queue.push(2);
    cout << queue.top() << endl;
    queue.pop();
    cout << queue.top() << endl;
    queue.pop();
}
