/**
 * fibonacciIterator.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Implements a Fibonacci Iterator.
 */

#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

class FibonacciIterator {
    unsigned long first = 0;
    unsigned long second = 1;
    size_t n = 0;
    
    void advance() {
        unsigned long tempFirst = first;
        first = second;
        second = tempFirst + second;
        n += 1;
    }
    
public:
    FibonacciIterator() {}
    
    FibonacciIterator(unsigned k) {
        for (unsigned i = 0; i < k; i += 1) {
            advance();
        }
    }
    
    unsigned long operator *() const {
        return first + second;
    }
    
    FibonacciIterator &operator++() {
        advance();
        return *this;
    }
    
    bool operator!=(const FibonacciIterator &other) {
        return n != other.n;
    }
};

int main() {
    // print first 10 Fibonacci numbers
    auto it = FibonacciIterator();
    auto end = FibonacciIterator(10);
    
    while (it != end) {
        cout << *it << endl;
        ++it;
    }
    
    // fill a vector with first 100 Fibonacci numbers
    const size_t n = 100;
    vector<unsigned long> first100(n);
    copy(FibonacciIterator(), FibonacciIterator(n), first1000.begin());
    // print the vectors' elements
    for (auto n : first1000) {
        cout << n << endl;
    }
}
