/**
 * anagrams.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Checks if two strings are anagrams.
 */

#include <iostream>
#include <string>
#include <algorithm>
#include <vector>
#include <set>
#include <functional>
#include <unordered_map>
#include <cassert>
using namespace std;

bool areAnagrams(const string& s1, const string& s2);
bool areAnagrams2(const string& s1, const string& s2);
bool areAnagrams3(const string& s1, const string& s2);

int main() {
    string s1 = "abbb";
    string s2 = "baaa";
    assert(areAnagrams(s1, s2) == false);
    assert(areAnagrams2(s1, s2) == false);
    assert(areAnagrams3(s1, s2) == false);
    s2 = "abbb";
    assert(areAnagrams(s1, s2) == true);
    assert(areAnagrams2(s1, s2) == true);
    assert(areAnagrams3(s1, s2) == true);
    s2 = "abbbb";
    assert(areAnagrams(s1, s2) == false);
    assert(areAnagrams2(s1, s2) == false);
    assert(areAnagrams3(s1, s2) == false);
    s2 = "Abbb";
    assert(areAnagrams(s1, s2) == false);
    assert(areAnagrams2(s1, s2) == false);
    assert(areAnagrams3(s1, s2) == false);

    cout << "Correct!" << endl;
}

bool areAnagrams(const string& s1, const string& s2) {
    // O(N)
    string copy1 = s1;
    string copy2 = s2;

    // O(N log(N))
    sort(copy1.begin(), copy1.end());
    sort(copy2.begin(), copy2.end());

    // O(1)
    return copy1 == copy2;
}


bool areAnagrams2(const string& s1, const string& s2) {
    // store number of occurrences for each character
    int characterCounts[CHAR_MAX] = {};

    // count occurrences of each character in s1
    // O(N)
    for (char c : s1) {
        characterCounts[c] += 1;
    }

    // subtract occurrences of each character in s2
    // O(N)
    for (char c : s2) {
        characterCounts[c] -= 1;

        // early return
        if (characterCounts[c] < 0) {
            return false;
        }
    }

    // verify matching counts
    // O(1)
    for (int i = 0; i < CHAR_MAX; i += 1) {
        if (characterCounts[i] != 0) {
            return false;
        }
    }
    return true;
}

bool areAnagrams3(const string& s1, const string& s2) {
    // store number of occurrences for each character
    unordered_map<char, int> characterCounts;

    // O(N)
    for (char c : s1) {
        ++characterCounts[c];
    }

    // O(N)
    for (char c : s2) {
        auto it = characterCounts.find(c);
        if (it == characterCounts.end()) {
            // not in s1
            return false;
        } else if (it->second == 1) {
            // last occurence
            characterCounts.erase(it);
        } else {
            it->second = it->second - 1;
        }
    }

    // O(1)
    return characterCounts.empty();
}
