/**
 * swapValues.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Demostrates templated functions.
 */


#include <iostream>
#include <string>
using namespace std;

/**
 * Tests swaps values of two variables of any type.
 */
template <typename T>
void swapValues(T& a, T& b);

/**
 * Tests swapValues function with ints.
 */
void testSwapInts();

/**
 * Tests swapValues function with strings.
 */
void testSwapStrings();

int main() {
    testSwapInts();
    testSwapStrings();
}

template <typename T>
void swapValues(T& a, T& b) {
    T temporaryA = a;
    a = b;
    b = temporaryA;
}

void testSwapInts() {
    int x = 2;
    int y = 5;
    
    cout << "x is " << x << endl;
    cout << "y is " << y << endl;
    cout << "Swapping..." << endl;
    swapValues(x, y);
    cout << "Swapped!" << endl;
    cout << "x is " << x << endl;
    cout << "y is " << y << endl;
}

void testSwapStrings() {
    string x = "two";
    string y = "five";
    
    cout << "x is " << x << endl;
    cout << "y is " << y << endl;
    cout << "Swapping..." << endl;
    swapValues(x, y);
    cout << "Swapped!" << endl;
    cout << "x is " << x << endl;
    cout << "y is " << y << endl;
}
