/**
 * namedStack.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Demostrates a templated class.
 */

#include <iostream>
#include <vector>
#include <string>
#include <exception>
using namespace std;

template <typename T>
class NamedStack {
    vector<T> items;
    string name;
public:
    // exception class for pop() with empty stack
    class EmptyNamedStackException: public exception {
    public:
        virtual const char* what() const throw() {
            return "stack is empty";
        }
    };
    // exception class for [] with invalid index
    class InvalidAccessNamedStackException: public exception {
    public:
        virtual const char* what() const throw() {
            return "invalid index";
        }
    };
    
    NamedStack(string newName): name(newName) {};
    void push(T newItem) {
        items.push_back(newItem);
    }
    T pop() {
        if (isEmpty()) {
            throw EmptyNamedStackException();
        }
        T topItem = items.back();
        items.pop_back();
        return topItem;
    }
    size_t size() const {
        return items.size();
    }
    bool isEmpty() const {
        return items.empty();
    }
    string getName() const {
        return name;
    }
    T& operator[] (const size_t index) {
        if (index < 0 || index >= size()) {
            throw InvalidAccessNamedStackException();
        }
        return items[index];
    }
    const T& operator[] (const size_t index) const {
        return items[index];
    }
};

template <typename T>
std::ostream &operator<<(std::ostream &os, const NamedStack<T> &stack) {
    os << stack.getName() << ": [";
    string separator = "";
    for (size_t i = 0; i < stack.size(); i += 1) {
        os << separator << stack[i];
        separator = ", ";
    }
    os << "]";
    return os;
}

int main() {
    NamedStack<string> tvShows("TV Shows");
    cout << tvShows << endl;
    tvShows.push("House of Cards");
    tvShows.push("Silicon Valley");
    cout << tvShows << endl;
    string tvShowToWatch = tvShows.pop();
    cout << "Watching: " << tvShowToWatch << endl;
    cout << "Remaining: " << tvShows << endl;
    tvShowToWatch = tvShows.pop();
    cout << "Watching: " << tvShowToWatch << endl;
    cout << "Remaining: " << tvShows << endl;
    // will throw an exception
    tvShowToWatch = tvShows.pop();
    cout << "Watching: " << tvShowToWatch << endl;
    cout << "Remaining: " << tvShows << endl;
    
}
