/**
 * vector.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Demonstrates vectors and pointer invalidation.
 */

#include <iostream>
#include <vector>
using namespace std;

void printVector(vector<int> vectorToPrint);

int main(int argc, char * argv[]) {

    vector<int> numbers = {183, 203, 280, 281};
    printVector(numbers);
    cout << "Capacity: " << numbers.capacity() << endl;

    int* favoriteCourse = &numbers[3];
    cout << "Favorite course: " << *favoriteCourse << endl;

    cout << "Adding 370..." << endl;
    numbers.push_back(370);
    printVector(numbers);
    cout << "Capacity: " << numbers.capacity() << endl;
    // invalid access
    cout << "Favorite course: " << *favoriteCourse << endl;

    return 0;
}

void printVector(vector<int> vectorToPrint) {
    cout << "{";
    /*
    for (int i = 0; i < vectorToPrint.size(); i += 1) {
        cout << " " << vectorToPrint[i];
    }
    */
    for (auto it = vectorToPrint.begin(); it != vectorToPrint.end(); ++it) {
        cout << " " << *it;
    }
    cout << " }" << endl;
}
