/**
 * temp.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Converts temperature.
 * Demonstrates getopt.
 */

#include <iostream>
#include <getopt.h>
using namespace std;

void printUsage(const string& program);
void printArguments();

void fahrenheitToCelsius(double fahrenheit);
void celsiusToFahrenheit(double celsius);

int main(int argc, char * argv[]) {

    string program = argv[0];

    // parse arguments
    struct option longOpts[] = {
        {"help", no_argument, nullptr, 'h'},
        {"celsius", required_argument, nullptr, 'c'},
        {"fahrenheit", required_argument, nullptr, 'f'},
        {nullptr, 0, nullptr, '\0'}
    };

    char option;
    int index = 0;
    int cFlags = 0;
    int fFlags = 0;
    double userTemperature = 0;

    while ((option = getopt_long(argc, argv, "hc:f:", longOpts, &index)) != -1) {
        switch (option) {
            case 'h':
                // help
                printUsage(program);
                printArguments();
                exit(0);
                break;
            case 'c':
                // celsius to fahrenheit
                try {
                    userTemperature = stod(optarg);
                } catch (exception e) {
                    printUsage(program);
                    exit(2);
                }
                cFlags += 1;
                break;
            case 'f':
                // fahrenheit to celsius
                try {
                    userTemperature = stod(optarg);
                } catch (exception e) {
                    printUsage(program);
                    exit(2);
                }
                fFlags += 1;
                break;
            default:
                printUsage(program);
                exit(1);
                break;
        }
    }

    // check arguments
    if (cFlags == 1 && fFlags == 0) {
        celsiusToFahrenheit(userTemperature);
    } else if (cFlags == 0 && fFlags == 1) {
        fahrenheitToCelsius(userTemperature);
    } else {
        printUsage(program);
        exit(1);
    }

    return 0;
}

void printUsage(const string& program) {
    cerr << "Usage: " << program << " [-h] -c|-f temperature" << endl;
}

void printArguments() {
    cout << "optonal arguments:" << endl;
    cout << "  -h, --help\t\tshow this help message and exit" << endl;
    cout << endl;
    cout << "required arguments:" << endl;
    cout << "  -c TEMP, --celsius TEMP\t\ttemperature in Celsius" << endl;
    cout << "  -f TEMP, --fahrenheit TEMP\t\ttemperature in Fahrenheit" << endl;
}

void fahrenheitToCelsius(double fahrenheit) {
    double celsius = 5.0 / 9 * (fahrenheit - 32);
    cout << fahrenheit << "°F is " << celsius << "°C" << endl;
}

void celsiusToFahrenheit(double celsius) {
    double fahrenheit = celsius * 9 / 5 + 32;
    cout << celsius << "°C is " << fahrenheit << "°F" << endl;
}
