/**
 * getopt.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Demonstrates getopt.
 */

#include <iostream>
#include <getopt.h>
using namespace std;

int main(int argc, char * argv[]) {

    struct option longOpts[] = {
        {"help", no_argument, nullptr, 'h'},
        {"output", required_argument, nullptr, 'o'},
        {nullptr, 0, nullptr, '\0'}
    };

    char option;
    int index = 0;
    while ((option = getopt_long(argc, argv, "ho:", longOpts, &index)) != -1) {
        switch (option) {
            case 'h':
                // print help message
                cout << "Help" << endl;
                break;

            case 'o':
                // decide output
                // get the required argument with optarg
                cout << optarg << endl;
                break;

            default:
                cerr << "Invalid option: " << option << endl;
                exit(1);
                break;
        }
    }


    return 0;
}
