/**
 * showers-2.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Calculates gallons of water and water bottles used when showering.
 * Uses correct pluralization.
 * Demonstrates calling functions.
 */


#include <iostream>
using namespace std;

/**
 * Requires: Nothing.
 * Modifies: Nothing.
 * Effects:  singular if number is 1, plural otherwise.
 */
string pluralize(string singular, string plural, int number);

int main()
{
    // constants
    const double NORMAL_GALLONS_PER_MINUTE = 20.0 / 8;
    const double NEBIA_GALLONS_PER_MINUTE = 6.0 / 8;
    const int OUNCES_PER_GALLON = 128;
    const int OUNCES_IN_BOTTLE = 16;
    
    // get input from user
    cout << "Minutes in shower: ";
    int minutesInShower;
    cin >> minutesInShower;
    
    // calculate gallons and bottles
    int normalGallons = minutesInShower * NORMAL_GALLONS_PER_MINUTE;
    int normalBottles = normalGallons * OUNCES_PER_GALLON / OUNCES_IN_BOTTLE;
    int nebiaGallons = minutesInShower * NEBIA_GALLONS_PER_MINUTE;
    int nebiaBottles = nebiaGallons * OUNCES_PER_GALLON / OUNCES_IN_BOTTLE;
    
    // print gallons and bottles for normal shower
    cout << "You used " << normalGallons << " "
         << pluralize("gallon", "gallons", normalGallons) << " of water "
         << "(" << normalBottles << " "
         << pluralize("bottle", "bottles", normalBottles) << " of water)"
         << " in a normal shower." << endl;
    
    // print gallons and bottles for Nebia shower
    cout << "You used " << nebiaGallons << " "
         << pluralize("gallon", "gallons", nebiaGallons) << " of water "
         << "(" << nebiaBottles << " "
         << pluralize("bottle", "bottles", nebiaBottles) << " of water)"
         << " in a Nebia shower." << endl;
}

string pluralize(string singular, string plural, int number)
{
    if (number == 1)
    {
        return singular;
    }
    else
    {
        return plural;
    }
}
