/**
 * showers-1.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Calculates gallons of water and water bottles used when showering.
 * Illustrates conversions.
 */


#include <iostream>
using namespace std;

int main()
{
    // constants
    const double NORMAL_GALLONS_PER_MINUTE = 20.0 / 8;
    const double NEBIA_GALLONS_PER_MINUTE = 6.0 / 8;
    const int OUNCES_PER_GALLON = 128;
    const int OUNCES_IN_BOTTLE = 16;
    
    // get input from user
    cout << "Minutes in shower: ";
    int minutesInShower;
    cin >> minutesInShower;
    
    // calculate gallons and bottles
    int normalGallons = minutesInShower * NORMAL_GALLONS_PER_MINUTE;
    int normalBottles = normalGallons * OUNCES_PER_GALLON / OUNCES_IN_BOTTLE;
    int nebiaGallons = minutesInShower * NEBIA_GALLONS_PER_MINUTE;
    int nebiaBottles = nebiaGallons * OUNCES_PER_GALLON / OUNCES_IN_BOTTLE;
    
    // print gallons and bottles for normal shower
    cout << "You used " << normalGallons << " gallons of water "
         << "(" << normalBottles << " bottles of water)"
         << " in a normal shower." << endl;
    
    // print gallons and bottles for Nebia shower
    cout << "You used " << nebiaGallons << " gallons of water "
         << "(" << nebiaBottles << " bottles of water)"
         << " in a Nebia shower." << endl;
}
