/**
 * students-2.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Demonstrates use of classes with public member variables and file I/O.
 *
 * Creates a CSV file with student information.
 */

#include <iostream>
#include <fstream>
#include "Student.h"
using namespace std;

/**
 * Requires: Nothing.
 * Modifies: cin, cout.
 * Effects:  Asks user for information about a student.
 *           Creates and returns new student.
 */
Student getStudent();

int main() {
    // create roster
    const int NUMBER_OF_STUDENTS = 3;
    Student roster[NUMBER_OF_STUDENTS];

    // populate roster
    for (int i = 0; i < NUMBER_OF_STUDENTS; i++) {
        roster[i] = getStudent();
        cout << endl;
    }

    // open file for writing
    const string FILENAME = "roster.csv";
    ofstream outputFileStream;
    outputFileStream.open(FILENAME);

    if (!outputFileStream) {
        cout << "Failed to open " << FILENAME << endl;
        return 1;
    }

    // print header
    outputFileStream << "Name,Email,Age" << endl;

    // save students to disk
    for (int i = 0; i < NUMBER_OF_STUDENTS; i++) {
        outputFileStream << roster[i].name << ","
                         << roster[i].email << ","
                         << roster[i].age << endl;
    }

    outputFileStream.close();
    cout << "Saved student data to " << FILENAME << endl;

    return 0;
}

Student getStudent() {
    Student newStudent;

    cout << "Student's name: ";
    string name;
    getline(cin, name);
    newStudent.name = name;

    cout << "Student's email: ";
    string email;
    getline(cin, email);
    newStudent.email = email;

    cout << "Student's age: ";
    int age;
    cin >> age;
    newStudent.age = age;

    // finish processing line
    string ignoredInput;
    getline(cin, ignoredInput);

    return newStudent;
}
