/**
 * students-1.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Demonstrates use of classes with public member variables.
 */

#include <iostream>
#include "Student.h"
using namespace std;

/**
 * Requires: Nothing.
 * Modifies: cin, cout.
 * Effects:  Asks user for information about a student.
 *           Creates and returns new student.
 */
Student getStudent();

int main() {
    // create roster
    const int NUMBER_OF_STUDENTS = 3;
    Student roster[NUMBER_OF_STUDENTS];

    // populate roster
    for (int i = 0; i < NUMBER_OF_STUDENTS; i++) {
        roster[i] = getStudent();
        cout << endl;
    }

    // print anyone over 21
    for (int i = 0; i < NUMBER_OF_STUDENTS; i++) {
        if (roster[i].age >= 21) {
            cout << roster[i].name << " is " << roster[i].age << "." << endl;
        }
    }
}

Student getStudent() {
    Student newStudent;

    cout << "Student's name: ";
    string name;
    getline(cin, name);
    newStudent.name = name;

    cout << "Student's email: ";
    string email;
    getline(cin, email);
    newStudent.email = email;

    cout << "Student's age: ";
    int age;
    cin >> age;
    newStudent.age = age;

    // finish processing line
    string ignoredInput;
    getline(cin, ignoredInput);

    return newStudent;
}
