/**
 * reverseCopy.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Copies each line of a text file to a new file, in reverse order.
 */


#include <iostream>
#include <string>
#include <fstream>
using namespace std;

int main() {
    // get original file
    cout << "Copy from: ";
    string originalFilename;
    getline(cin, originalFilename);
    ifstream originalFileStream;
    originalFileStream.open(originalFilename);
    if (!originalFileStream.good()) {
        cout << "Could not open " << originalFilename << endl;
        return 1;
    }

    // get output file
    cout << "Copy to: ";
    string newFilename;
    getline(cin, newFilename);
    ofstream newFileStream;
    newFileStream.open(newFilename);
    if (!newFileStream.good()) {
        cout << "Could not open " << newFilename << endl;
        return 1;
    }

    // collect new file contents
    string newFileContents = "";
    while (originalFileStream.good() && newFileStream.good()) {
        string lineFromOriginal;
        getline(originalFileStream, lineFromOriginal);
        newFileContents = lineFromOriginal + "\n" + newFileContents;
    }

    // write new file
    newFileStream << newFileContents;

    // finished!
    cout << "(Reverse-)copied " << originalFilename << " to " << newFilename << endl;
    return 0;
}
