/**
 * positive-2.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Asks the user for a positive integer until the user cooperates.
 *
 * Demostrates input validation. Uses a function.
 */

#include <iostream>
using namespace std;

/**
 * Requires: Nothing.
 * Modifies: cin, cout.
 * Effects:  Reads a positive integer. Keeps asking the user until the user
 *           cooperates.
 */
int getPositiveInt();

int main() {
    cout << "Please give me a positive integer: ";
    int n = getPositiveInt();
    cout << "Thanks for the " << n << "!" << endl;
}

int getPositiveInt() {
    int input;
    cin >> input;
    while (input < 1) {
        // clear input
        if (cin.fail()) {
            cin.clear();
            string ignoredInput;
            getline(cin, ignoredInput);
        }

        // read another integer
        cout << "Try again: ";
        cin >> input;
    }

    return input;
}
