/**
 * copy.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Copies each line of a text file to a new file.
 */


#include <iostream>
#include <string>
#include <fstream>
using namespace std;

int main() {
    // get original file
    cout << "Copy from: ";
    string originalFilename;
    getline(cin, originalFilename);
    ifstream originalFileStream;
    originalFileStream.open(originalFilename);
    if (!originalFileStream.good()) {
        cout << "Could not open " << originalFilename << endl;
        return 1;
    }
    
    // get output file
    cout << "Copy to: ";
    string newFilename;
    getline(cin, newFilename);
    ofstream newFileStream;
    newFileStream.open(newFilename);
    if (!newFileStream.good()) {
        cout << "Could not open " << newFilename << endl;
        return 1;
    }
    
    // copy line by line
    while (originalFileStream.good() && newFileStream.good()) {
        string lineToCopy;
        getline(originalFileStream, lineToCopy);
        newFileStream << lineToCopy << endl;
    }
    
    // finished!
    cout << "Copied " << originalFilename << " to " << newFilename << endl;
    return 0;
}
