/**
 * triangles.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Determines the type of triangle.
 * Demonstrates use of if - else statements
 */

#include <iostream>
#include <string>
using namespace std;

int getSideLength(string side);

int main()
{
    int sideA = getSideLength("a");
    int sideB = getSideLength("b");
    int sideC = getSideLength("c");
    
    if (sideA + sideB < sideC || sideA + sideC < sideB || sideB + sideC < sideA)
    {
        // a single side is longer than the sum of the other two
        cout << "Invalid triangle" << endl;
    }
    else if (sideA == sideB && sideB == sideC)
    {
        // all three side lengths are equal
        cout << "Equilateral" << endl;
    }
    else if (sideA == sideB || sideA == sideC || sideB == sideC)
    {
        // two side lengths are equal
        cout << "Isosceles" << endl;
    }
    else
    {
        // different side lengths
        cout << "Scalene" << endl;
    }
}

int getSideLength(string side)
{
    cout << "What is the length of side " << side << "? ";
    int length;
    cin >> length;
    return length;
}
