/**
 * random.cpp
 *
 * Maxim Aleksa
 * maximal@umich.edu
 *
 * Pseudorandomly chooses a student from a list.
 */

#include <iostream>
#include <string>
#include <ctime>
#include <cstdlib>
#include <chrono>
#include <thread>
#include "students.h"
using namespace std;

int main() {
    
    cout << "Rolling a " << NUMBER_OF_STUDENTS << "-sided die..." << endl;
    
    // initialize random seed
    srand(static_cast<unsigned int>(time(NULL)));
    
    // suspense for 10 seconds
    for (int i = 0; i < 10; i++)
    {
        cout << rand() % NUMBER_OF_STUDENTS << endl;
        std::this_thread::sleep_for(std::chrono::milliseconds(1000));
    }
    
    // print the winner
    cout << "And the winner is... " << students[rand() % NUMBER_OF_STUDENTS];
    cout << endl;
    
    return 0;
}
